
//scilab 5.5.2 , OS: Ubuntu 14.04
//Design a digital resonator that resonates at 1000 Hz. Assume Fs=8000 Hz.
// Calculate the pole location
//w=2*pi*f/fs;
//Complex conjugate pair of poles at w=pi/4 and -pi/4
//Assume radius=0.98 (near to unit circle but inside the unit circle)
 
//Scilab Program: 
clc;
clear;
close;
f=1000;//input("Enter the frequency in Hz");    //1000
fs=8000;//input("Enter the sampling rate");     //8000
r=0.98;//input("Enter the radius of the pole in the z-plane");   //0.98
w=2*%pi*f/fs;
pole1=r*exp(%i*w);
pole2=r*exp(-%i*w);

z=%z;

num1=real(z^(2));
den1=real(z^(2)-1.3859293*z+0.9604);
Hz=num1./den1;
//figure;
//plzr(Hz);
[h1 fr]=frmag(Hz,1024);
figure;
plot2d(fr*fs,h1);
xtitle('Magnitude response','frequency in Hz','Mag');


